/* ToUpperDA.h
 * toupper function (Desk Accessory)
 *
 * by TERADA, Koichi
 * email: kterada@iname.com
 * web:   http://home.earthlink.net/~terada/
 */

typedef unsigned char uchar;

#define	MAX_TEXT			255
#define MAX_DISPLAY			20

#define	mainFormLeft		0
#define	mainFormWidth		160
#define	mainFormTop			40
#define	mainFormHeight		120
#define	FrameWidth			2

#define ResistorDA_AppID	'DARs'

#define	ResistorSymbolLeft	138
#define	ResistorBand1Top	61
#define	ResistorBand2Top	65
#define	ResistorBand3Top	69
#define	ResistorBand4Top	73
#define	ResistorBand5Top	81

#define chrIsHardKey(c)     ((((c) >= hardKeyMin) && ((c) <= hardKeyMax)) || ((c) == calcChr))

enum {
	BANDS_4BANDS,
	BANDS_5BANDS
};
enum {
	BAND_BLACK,
	BAND_BROWN,
	BAND_RED,
	BAND_ORANGE,
	BAND_YELLOW,
	BAND_GREEN,
	BAND_BLUE,
	BAND_VIOLET,
	BAND_GRAY,
	BAND_WHITE,
	BAND_GOLD,
	BAND_SILVER,
	BAND_NULL
};
#define	MAX_BAND	(BAND_NULL+1)

enum {
	BAND5_BROWN,
	BAND5_RED,
	BAND5_GOLD,
	BAND5_SILVER
};


typedef struct parameter {
	Short	bands;
	Word	band_1;
	Word	band_2;
	Word	band_3;
	Word	band_4;
	Word	band_5;
	VoidHand	dataRsrcH[MAX_BAND];
	VoidPtr		colorbarP[MAX_BAND];
	Char resultStr[MAX_TEXT];
	Char errorStr[MAX_TEXT];
} Param;

typedef struct {
	Short	bands;
	Char	band_1;
	Char	band_2;
	Char	band_3;
	Char	band_4;
	Char	band_5;
} ResistorDAPreferenceType;

#define ResistorDAPrefVersionNum	2


static int EventMainLoop( Param * );
static Boolean HandleMainEvent(EventPtr, Param *);
static void LoadFromPrefs( Param * );
static void SaveToPrefs( Param * );
static void getColorBars( Param *param );
static void releaseColorBars( Param *param );
static void updateResistorSymbol( Param *param );
static void frmSetObjectValue( FormPtr form, Word id, Boolean value );
static void setAndDrawFields( Param *param );
static void showThirdBand( Param *param, FormPtr form );
static void hideThirdBand( Param *param, FormPtr form );
static Boolean isColorDevice( void );
static void updateResultField( Param *param );
static void formatResistorValue( Param *param );


/*  $Revision: 1.6 $
 *
 *  $Log: ResistorDA.h,v $
 *  Revision 1.6  2001/05/02 13:43:37  kterada
 *  add ohm symbol
 *
 *  Revision 1.5  2001/05/01 18:47:46  kterada
 *  omit the first zero
 *
 *  Revision 1.4  2001/05/01 18:35:19  kterada
 *  add gold/silver offset
 *
 *  Revision 1.3  2001/05/01 18:25:45  kterada
 *  *** empty log message ***
 *
 *  Revision 1.2  2001/05/01 18:03:14  kterada
 *  working version
 *
 *  Revision 1.1.1.1  2001/04/30 17:45:35  kterada
 *  Resistor Calcurater DA
 *
 */



